<?php
session_start();
include 'connection.php';
date_default_timezone_set('Asia/Calcutta');

$today = date("Y-m-d");
$time = date("h:i A");

if (!isset($_SESSION['is_logged_in'])) {
    echo "Session expired. Please log in again.";
    exit;
}

$login_name = $_SESSION["LOGIN_NAME"];
$login_pass = $_SESSION["EMPLOYEE_PASSWORD"];

$querylogin = "SELECT * FROM mst_users WHERE user_name = ? AND password = ?";
$stmt = $conn->prepare($querylogin);
$stmt->bind_param("ss", $login_name, $login_pass);
$stmt->execute();
$result = $stmt->get_result();
$user = $result->fetch_assoc();
$stmt->close();

if (!$user) {
    echo "Invalid user session.";
    exit;
}

$entry_by     = $user['user_id'];
$jcno         = $_REQUEST['jcno'] ?? '';
$step         = intval($_REQUEST['step'] ?? 0);
$final_status = isset($_POST['final_status']) ? 1 : 0;
$stage        = $_POST['stage'] ?? '';
$lead_id      = $_REQUEST['lead_id'] ?? '';
$carpenter_id = $_POST['carpenter_id'] ?? '';
$pm_id        = $_POST['pm_id'] ?? '';

if (empty($jcno)) {
    echo "Invalid JCNO.";
    exit;
}

// Update current status and stage
$sql = "UPDATE Job_order_Status SET status = ?, stage = ? WHERE jcno = ?";
$stmt = $conn->prepare($sql);
$status_val = $final_status ? 'Validated' : 'Pending';
$stmt->bind_param("sss", $status_val, $stage, $jcno);
$stmt->execute();
$stmt->close();

// If final_status is ON, log and advance stage
if ($final_status) {
    $current_step = $step;

    // Get current stage name
    $stage_sql = "SELECT stage FROM Stage_master WHERE step = ?";
    $stage_stmt = $conn->prepare($stage_sql);
    $stage_stmt->bind_param("i", $current_step);
    $stage_stmt->execute();
    $stage_result = $stage_stmt->get_result();
    $stage_row = $stage_result->fetch_assoc();
    $current_stage = $stage_row['stage'] ?? 'Unknown';
    $stage_stmt->close();

    // Insert into history
    $entry_date = date('Y-m-d');
    $entry_time = date('H:i:s');

    $history_stmt = $conn->prepare("
        INSERT INTO job_order_history 
        (jcno, stage, step, entry_by, entry_date, entry_time, status, carpenter, project_mangaer) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
    ");
    $history_stmt->bind_param(
        "ssissssss",
        $jcno,
        $current_stage,
        $current_step,
        $entry_by,
        $entry_date,
        $entry_time,
        $current_stage,
        $carpenter_id,
        $pm_id
    );
    $history_stmt->execute();
    $history_stmt->close();

    // Move to next step
    $new_step = $current_step + 1;

    $stage_stmt = $conn->prepare("SELECT stage, status FROM Stage_master WHERE step = ?");
    $stage_stmt->bind_param("i", $new_step);
    $stage_stmt->execute();
    $stage_result = $stage_stmt->get_result();
    $stage_row = $stage_result->fetch_assoc();
    $new_status = $stage_row['status'] ?? 'Pending';
    $new_stage  = $stage_row['stage'] ?? '';
    $stage_stmt->close();

    // Update Job_order_Status with new step + allocation
    $update_stmt = $conn->prepare("
        UPDATE Job_order_Status 
        SET status = ?, step = ?, stage = ?, carpenter = ?, project_mangaer = ? 
        WHERE jcno = ?
    ");
    $update_stmt->bind_param(
        "sissss",
        $new_status,
        $new_step,
        $new_stage,
        $carpenter_id,
        $pm_id,
        $jcno
    );
    $update_stmt->execute();
    $update_stmt->close();

    // Update customer_leads if step 5
    if ($new_step == 5) {
        $cust_stmt = $conn->prepare("UPDATE customer_leads SET order_stage = ? WHERE lead_id = ?");
        $cust_stmt->bind_param("si", $new_stage, $lead_id);
        $cust_stmt->execute();
        $cust_stmt->close();
    }

    echo "Saved successfully. Status moved to next step.";

} else {
    echo "Saved, but awaiting all validations to proceed.";
}

$conn->close();
?>
