<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    header('Content-Type: application/json');
    $lead_id = $_POST['lead_id'];
    $remark = $_POST['remark'];
    
    // Simulate DB save here
    echo json_encode([
        'status' => 'success',
        'message' => 'Remark saved successfully!',
        'remark' => htmlspecialchars($remark)
    ]);
    exit; 
}
?>

<!DOCTYPE html>
<html>
<head>
  <title>Test Remark</title>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body>
  <div id="remarkCell123">
    Old remark<br>
    <button class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#remarkModal123">Remark</button><br>
    
  </div>

  <!-- Fake modal -->
  <div id="remarkModal123">
    <form class="remark-form" action="test_remark.php" method="POST">
      <input type="hidden" name="lead_id" value="123">
      <textarea name="remark">New remark</textarea>
      <button type="submit">Save</button>
    </form>
  </div>

  <script>
    $('.remark-form').on('submit', function(e) {
      e.preventDefault();
      var form = $(this);
      var formData = form.serialize();
      var leadId = form.find('input[name="lead_id"]').val();

      $.ajax({
        type: 'POST',
        url: form.attr('action'),
        data: formData,
        dataType: 'json',
        success: function(response) {
          alert(response.message);
          const targetCell = $('#remarkCell' + leadId);
          const existingButton = targetCell.find('button').prop('outerHTML');
          targetCell.html(
            response.remark + '<br>' +
            existingButton + '<br>' +
            '<small>Last conversation: <span id="lastRemark' + leadId + '">' + response.remark + '</span></small>'
          );
        },
        error: function(xhr, status, error) {
          alert('Error occurred: ' + error);
          console.log(xhr.responseText);
        }
      });
    });
  </script>
</body>
</html>
