<?php
ob_clean();
session_start();
header('Content-Type: application/json');
include 'connection.php';

if (!isset($_SESSION['is_logged_in'])) {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

if (!isset($_SESSION["LOGIN_NAME"]) || !isset($_SESSION["EMPLOYEE_PASSWORD"])) {
    echo json_encode(['status' => 'error', 'message' => 'Session missing']);
    exit;
}

// Authenticate user
$querylogin = "SELECT * FROM mst_users WHERE user_name = ? AND password = ?";
$stmtLogin = $conn->prepare($querylogin);
$stmtLogin->bind_param("ss", $_SESSION["LOGIN_NAME"], $_SESSION["EMPLOYEE_PASSWORD"]);
$stmtLogin->execute();
$resultlogin = $stmtLogin->get_result();
$branch = '';
$user_id = '';

if ($row = $resultlogin->fetch_assoc()) {
    $branch = $row['branch'];
    $user_id = $row['user_id'];
}
$stmtLogin->close();

$login_id = $_SESSION['user_id'] ?? $user_id;
$LOGIN_NAME = $_SESSION['username'] ?? $_SESSION['LOGIN_NAME'];
$today = date('Y-m-d');

// Get form data
$call_followup_id = $_POST['call_followup_id'] ?? '';
$followup_id = $_POST['followup_id'] ?? '';
$followup_type = $_POST['followup_type' . $call_followup_id] ?? '';
$followup_details = $_POST['followup_details'] ?? '';
$next_reminder_date = $_POST['next_reminder_date'] ?? '';
$next_reminder_time = $_POST['next_reminder_time'] ?? '';

// Validate
if (empty($call_followup_id) || empty($followup_id) || empty($followup_type)) {
    echo json_encode(['status' => 'error', 'message' => 'Required fields missing.']);
    exit;
}

// Fetch previous followup info
$sqlFetch = "SELECT firm_id, architect_id, new_architect_name, architect_mobile_no, architect_name
             FROM architect_followup WHERE followup_id = ?";
$stmtFetch = $conn->prepare($sqlFetch);
$stmtFetch->bind_param("i", $followup_id);
$stmtFetch->execute();
$result = $stmtFetch->get_result();

if ($result->num_rows === 0) {
    echo json_encode(['status' => 'error', 'message' => 'No matching follow-up found.']);
    exit;
}
$row = $result->fetch_assoc();
$stmtFetch->close();

// Insert new follow-up
$insert = "INSERT INTO architect_followup (
    call_followup_id, firm_id, architect_id, new_architect_name, architect_mobile_no,
    followup_details, next_reminder_date, next_reminder_time, followup_type, architect_name, entry_by
) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

$stmtInsert = $conn->prepare($insert);

if (!$stmtInsert) {
    echo json_encode(['status' => 'error', 'message' => 'Insert prepare failed: ' . $conn->error]);
    exit;
}

$stmtInsert->bind_param(
    "issssssssss",
    $call_followup_id,
    $row['firm_id'],
    $row['architect_id'],
    $row['new_architect_name'],
    $row['architect_mobile_no'],
    $followup_details,
    $next_reminder_date,
    $next_reminder_time,
    $followup_type,
    $row['architect_name'],
	$login_id
);

if (!$stmtInsert->execute()) {
    echo json_encode(['status' => 'error', 'message' => 'Insert execution failed: ' . $stmtInsert->error]);
    exit;
}
$stmtInsert->close();

// Update main follow-up status
$update = "UPDATE call_follow_up SET step_name = ? WHERE call_follow_up_id = ?";
$stmtUpdate = $conn->prepare($update);

if ($stmtUpdate) {
    $stmtUpdate->bind_param("si", $followup_type, $call_followup_id);
    $stmtUpdate->execute();
    $stmtUpdate->close();
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Update prepare failed: ' . $conn->error
    ]);
    exit;
}

// Final success response
echo json_encode([
    'status' => 'success',
    'message' => 'Follow-up saved successfully.',
    'remark' => $followup_details
]);

$conn->close();
?>
