<?php include 'connection.php'; 
ob_start();
error_reporting(0);
//include 'sahavas_function.php';
session_start();
if (!isset($_SESSION['is_logged_in'])) {
header("Location:login.php");
die();
}

$querylogin = "select * from mst_users where user_name = '". $_SESSION["LOGIN_NAME"]."' AND password = '".$_SESSION["EMPLOYEE_PASSWORD"]."'";
$resultlogin = mysqli_query($conn,$querylogin);
while($row=mysqli_fetch_array($resultlogin))
{
$name = $row['name'];
$user_id_self = $row['user_id'];
$branch = $row['branch'];
$login_type=$row['login_type'];

}

?>

<!DOCTYPE html>

<html lang="en">

<head>

<meta charset="UTF-8">

<title>Lead Tracker Overview</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script><!-- jQuery (required) -->

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- DataTables (Bootstrap integration) -->
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
<style>
   body, html {
  height: 100%;
  margin: 0;
  overflow: hidden;
  font-family: 'Roboto', sans-serif;
  font-size: 14px;
  background-color: #f1f3f6;
}
  .header-fixed {
  position: sticky;
  top: 0;
  z-index: 1000;
  background: linear-gradient(90deg, #0d6efd, #0dcaf0);
  box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
  border-bottom: 2px solid #0d6efd;
  border-radius: 0 0 12px 12px;
}

.header-fixed h4 {
  font-family: 'Roboto', sans-serif;
  font-size: 1rem;
  letter-spacing: 0.5px;
}
.header-fixed i {
  animation: pulse 1.5s infinite;
}

@keyframes pulse {
  0% { transform: scale(1); opacity: 1; }
  50% { transform: scale(1.1); opacity: 0.8; }
  100% { transform: scale(1); opacity: 1; }
}
  .table-container {
  max-height: calc(100vh - 300px); /* adjust based on your header + form height */
  overflow-y: auto;
  background-color: #fff;
  border-radius: 12px;
  box-shadow: 0 4px 16px rgba(0, 0, 0, 0.05);
}
    h4 i {
      color: #0d6efd;
    }
   .table-container {
  max-height: 550px;
  overflow-y: auto;
  border: 0px solid #dee2e6; z-index:100;
}

.sticky-header th {
  position: sticky;
  top: 0;
  background-color: #FFCC00;
  color: #000;
  z-index: 10;
  font-weight: bold;
  text-align: center;
}

/* Optional: Style scroll bar (Chrome/WebKit) */
.table-container::-webkit-scrollbar {
  width: 8px;
}
.table-container::-webkit-scrollbar-thumb {
  background-color: rgba(0, 0, 0, 0.2);
  border-radius: 4px;
}

    .table thead {
      background-color: #0d6efd;
      color: #fff;
    }
    .table th {
      font-size: 14px;
      letter-spacing: 0.5px;
    }
    .badge-status {
      padding: 6px 12px;
      font-size: 0.75rem;
      border-radius: 30px;
    }
    .badge-hot {
      background-color:#FFCC00;
      color: #000;
    }
    .badge-warm {
      background-color:#FF9900;
      color: #fff;
    }
    .badge-cold {
      background-color: #1B84FF;
      color: #fff;
    }
	
	.badge-cold1 {
      background-color:#FF66FF;
      color: #000;
    }
    .badge-stage {
      background-color: #f1f3f5;
      color: #444;
    }
    td, th {
      vertical-align: middle !important;
    }
    .project-info strong {
      font-size: 1rem;
      color: #333;
    }
    .project-info small {
      display: block;
      font-size: 0.85rem;
      color: #666;
    }
    .project-info ul {
      padding-left: 1rem;
      margin: 0.25rem 0 0;
    }
    .project-info ul li {
      font-size: 0.85rem;
      color: #444;
    }
    tr:hover {
      background-color: #f6f9fc;
    }
	
  </style>

  <style>

.status-icon {

    width: 35px;

    height: 35px;

    object-fit: contain;

    border-radius: 8px;

    margin-right: 5px;

}

</style>
</head>

<body> 

<div class="header-fixed position-relative text-center py-3 shadow-sm bg-dark text-white">

<h2 class="mb-0 fw-bold"><?php     if($login_type!='user') {   ?><button class="btn btn-info mb-3" onClick="toggleFilterForm()" style="float:left; margin-left:20px;">Open Filter</button><?php } ?><i class="fas fa-clipboard-list me-2 text-warning"></i> Lead Activity Report</h2>
<a href="<?php if($_REQUEST['back']=='user') {?>index_user.php<?php }elseif($_REQUEST['back']=='user1') {?>index.php <?php }else{ ?>index_admin.php<?php } ?>" class="btn btn-outline-light position-absolute top-50 end-0 translate-middle-y me-4"> <i class="fas fa-arrow-left me-1"></i> Back to Dashboard </a>

</div>

<div class="flex-grow-1 overflow-auto p-3">

<!--  Search Form -->

<div class="card mb-4 shadow-sm p-3" id="filterFormContainer" style="display: none;">

<form method="GET" class="row g-3 align-items-end">

<div class="col-md-3">

<label for="customer_name" class="form-label">Client Name</label>

<input type="text" id="customer_name" name="customer_name" class="form-control" placeholder="Enter name" value="<?= htmlspecialchars($_GET['customer_name'] ?? '') ?>">

</div>

<div class="col-md-2">

<label for="from_date" class="form-label">From Date</label>

<input type="date" id="from_date" name="from_date" class="form-control" value="<?= htmlspecialchars($_GET['from_date'] ?? '') ?>">

</div>

<div class="col-md-2">

<label for="to_date" class="form-label">To Date</label>

<input type="date" id="to_date" name="to_date" class="form-control" value="<?= htmlspecialchars($_GET['to_date'] ?? '') ?>">

</div>

<div class="col-md-2">

<label for="enquiry_priority" class="form-label">Lead Temp</label>

<select id="enquiry_priority" name="enquiry_priority" class="form-select">

<option value="">All</option>

<option value="Hot" <?= ($_GET['enquiry_priority'] ?? '') === 'Hot' ? 'selected' : '' ?>>Hot</option>

<option value="Warm" <?= ($_GET['enquiry_priority'] ?? '') === 'Warm' ? 'selected' : '' ?>>Warm</option>

<option value="Cold" <?= ($_GET['enquiry_priority'] ?? '') === 'Cold' ? 'selected' : '' ?>>Cold</option>

</select>

</div>
 <?php     if($login_type!='user') {   ?>

<div class="col-md-3">
<label for="lead_owner" class="form-label">Lead Owner</label>
<input type="text" id="lead_owner" name="lead_owner" class="form-control" placeholder="Enter owner name" value="<?= htmlspecialchars($_GET['lead_owner'] ?? '') ?>">
</div>
<div class="col-md-2">

<label for="branch" class="form-label">Branch</label>

<select id="branch" name="branch" class="form-select">
    <option value="">All Branches</option>

    <?php
    $branchResult = mysqli_query($conn, "SELECT DISTINCT branch_name FROM branch_master ORDER BY branch_name ASC");
    $currentBranch = $_GET['branch'] ?? '';

    // Normal branches
    while ($b = mysqli_fetch_assoc($branchResult)) {
        $selected = ($currentBranch === $b['branch_name']) ? 'selected' : '';
        echo "<option value='" . htmlspecialchars($b['branch_name']) . "' $selected>" . htmlspecialchars($b['branch_name']) . "</option>";
    }

    // Add "Unknown" option (represents blank in DB)
    $selected = ($currentBranch === 'Unknown') ? 'selected' : '';
    echo "<option value='' $selected>Unknown</option>";
    ?>
</select>
</div><?php }

?>

<div class="col-md-2">

<label for="status" class="form-label">Status</label>

<select id="status" name="status" class="form-control form-select">
<option value="">All</option>
<option value="Lead" <?= ($_GET['status'] ?? '') === 'Lead' ? 'selected' : '' ?>>Lead</option>
<option value="Lead" <?= ($_GET['status'] ?? '') === 'Quotation Sent' ? 'selected' : '' ?>>Quotation Sent</option><?php /*?><option value="Lost" <?= ($_GET['status'] ?? '') === 'Lost' ? 'selected' : '' ?>>Lost</option>

<?php */?><option value="Closed" <?= ($_GET['status'] ?? '') === 'Closed' ? 'selected' : '' ?>>Closed</option></select>

</div>

<div class="col-md-2">

<label for="enquiry_status" class="form-label">Enquiry Status</label>

<select id="enquiry_status" name="enquiry_status" class="form-select">

<option value="">All</option>

<option value="Initial_Measurement_Done" <?= ($_GET['enquiry_status'] ?? '') === 'Initial_Measurement_Done' ? 'selected' : '' ?>>Initial Measurement Done</option>

<option value="Design_Submitted" <?= ($_GET['enquiry_status'] ?? '') === 'Design_Submitted' ? 'selected' : '' ?>>Design Submitted</option>

<option value="Quote_Submitted" <?= ($_GET['enquiry_status'] ?? '') === 'Quote_Submitted' ? 'selected' : '' ?>>Quote Ready</option>

<option value="Order_Closed" <?= ($_GET['enquiry_status'] ?? '') === 'Order_Closed' ? 'selected' : '' ?>>Order Closed</option>

<option value="Order_Placed" <?= ($_GET['enquiry_status'] ?? '') === 'Order_Placed' ? 'selected' : '' ?>>Order Placed</option>

<option value="In_Discussion" <?= ($_GET['enquiry_status'] ?? '') === 'In_Discussion' ? 'selected' : '' ?>>In Discussion</option>

<option value="Site_Handovered" <?= ($_GET['enquiry_status'] ?? '') === 'Site_Handovered' ? 'selected' : '' ?>>Site Handovered</option>

<option value="Site_Handover" <?= ($_GET['enquiry_status'] ?? '') === 'Site_Handover' ? 'selected' : '' ?>>Site Handover</option>

</select>

</div>

<div class="col-md-3">

<label for="architech_name" class="form-label">Architect Name</label>

<input type="text" id="architech_name" name="architech_name" class="form-control" placeholder="Enter architect name" value="<?= htmlspecialchars($_GET['architech_name'] ?? '') ?>">

</div>
<div class="col-md-3">

<label for="architech_name" class="form-label">Ref. Name</label>

<input type="text" id="ref_name" name="ref_name" class="form-control" placeholder="Enter Ref. name" value="<?= htmlspecialchars($_GET['ref_name'] ?? '') ?>">

</div><div class="col-md-2 text-end">

<button type="submit" class="btn btn-primary w-100 mb-2">Search</button>

<?php if (isset($_GET['lead_owner'])): ?>

    <a href="report1_admin.php?lead_owner=<?= urlencode($_GET['lead_owner']) ?>" class="btn btn-outline-secondary w-100">Reset</a>

<?php endif; ?>

</div>

<div class="col-md-2 text-end">

<!--<button type="submit" class="btn btn-success w-100 mb-2" formaction="export_excel.php"> <i class="fas fa-file-excel"></i> Export to Excel </button>-->

</div>

</form>

</div>

<script>

function toggleFilterForm() {

    const form = document.getElementById("filterFormContainer");

    if (form.style.display === "none") {

        form.style.display = "block";

    } else {

        form.style.display = "none";

    }

}

</script>

<div class="table-container table-responsive">


<table id="leadsTable" class="table table-bordered table-hover text-center align-middle">

<thead class="custom-header sticky-header">

<tr>

<th colspan="14"><?php
$lead_owner = isset($_GET['lead_owner']) ? urldecode($_GET['lead_owner']) : '';
$status     = isset($_GET['status']) ? $_GET['status'] : '';
$month     = isset($_GET['month']) ? $_GET['month'] : '';
$branch = isset($_GET['branch']) ? urldecode($_GET['branch']) : '';

if (!empty($lead_owner) || !empty($status) && empty($month) && empty($branch)) {

    if (!empty($lead_owner)) {
        // === Case 1: lead_owner is given → show that designer's data ===
        $user_sql = "SELECT user_id FROM mst_users WHERE name = ?";
        $stmt = $conn->prepare($user_sql);
        $stmt->bind_param("s", $lead_owner);
        $stmt->execute();
        $user_result = $stmt->get_result();

        if ($user_result->num_rows > 0) {
            $user = $user_result->fetch_assoc();
            $user_id = $user['user_id'];

            // Get counts
            $lead_sql = "
                SELECT 
                    SUM(status = 'Closed')          AS closed_count,
                    SUM(status = 'Lost')            AS lost_count,
                    SUM(status = 'Lead')            AS open_count,
                    SUM(status = 'Quotation Sent')  AS quotation_count
                FROM customer_leads 
                WHERE assign_to = ?
            ";
            $stmt2 = $conn->prepare($lead_sql);
            $stmt2->bind_param("i", $user_id);
            $stmt2->execute();
            $lead_result = $stmt2->get_result();
            $leads = $lead_result->fetch_assoc();

            $customer_sql = "SELECT COUNT(*) as total_customers FROM customer_leads WHERE assign_to = ?";
            $stmt3 = $conn->prepare($customer_sql);
            $stmt3->bind_param("i", $user_id);
            $stmt3->execute();
            $customer_result = $stmt3->get_result();
            $customer_data = $customer_result->fetch_assoc();
            $total_customers = $customer_data['total_customers'];
        }
    } else {
        // === Case 2: Only status given → show global stats (all designers) ===
        $lead_sql = "
            SELECT 
                SUM(status = 'Closed')          AS closed_count,
                SUM(status = 'Lost')            AS lost_count,
                SUM(status = 'Lead')            AS open_count,
                SUM(status = 'Quotation Sent')  AS quotation_count
            FROM customer_leads
        ";
        $lead_result = $conn->query($lead_sql);
        $leads = $lead_result->fetch_assoc();

        $customer_sql = "SELECT COUNT(*) as total_customers FROM customer_leads";
        $customer_result = $conn->query($customer_sql);
        $customer_data = $customer_result->fetch_assoc();
        $total_customers = $customer_data['total_customers'];
    }
?>

<!-- HTML Card -->
<?php
$current_status = $_GET['status'] ?? ''; // Get current status from URL
?>

<div class="card border-dark border-2 mb-4">
  <div class="card-body" style="font-size: 18px; display: flex; align-items: center; flex-wrap: wrap; gap: 20px;">

    <?php if (!empty($lead_owner)) : ?>
      <span><b>Entry By / Designer:</b> <?= htmlspecialchars($lead_owner) ?>,</span>
    <?php endif; ?>

    <span><b>No Of Customer:</b> <span style="color:red;"><?= $total_customers ?></span></span>

    <!-- Win -->
    <a href="report1_admin.php?<?= !empty($lead_owner) ? 'lead_owner='.urlencode($lead_owner).'&' : '' ?>status=Closed">
      <span style="<?= $current_status === 'Closed' ? 'background:#e6ffe6; padding:5px; border-radius:5px;' : '' ?>">
        <b>Win:</b> 
        <img src="thumbs_up_sign_256_1.gif" style="height:20px; vertical-align:middle;" /> 
        <span style="color:green;"><?= $leads['closed_count'] ?></span>
      </span>
    </a>

    <!-- Lost -->
    <a href="report1_admin.php?<?= !empty($lead_owner) ? 'lead_owner='.urlencode($lead_owner).'&' : '' ?>status=Lost">
      <span style="<?= $current_status === 'Lost' ? 'background:#ffe6e6; padding:5px; border-radius:5px;' : '' ?>">
        <b>Lost:</b> 
        <img src="tenor.gif" style="height:20px; vertical-align:middle;" /> 
        <span style="color:red;"><?= $leads['lost_count'] ?></span>
      </span>
    </a>

    <!-- Lead -->
    <a href="report1_admin.php?<?= !empty($lead_owner) ? 'lead_owner='.urlencode($lead_owner).'&' : '' ?>status=Lead">
      <span style="<?= $current_status === 'Lead' ? 'background:#fff3cd; padding:5px; border-radius:5px;' : '' ?>">
        <b>Lead:</b> 
        <img src="lg.sandglass-time-loading-gif.gif" style="height:20px; vertical-align:middle;" /> 
        <span style="color:orange;"><?= $leads['open_count'] ?></span>
      </span>
    </a>

    <!-- Quotation Sent -->
    <a href="report1_admin.php?<?= !empty($lead_owner) ? 'lead_owner='.urlencode($lead_owner).'&' : '' ?>status=Quotation%20Sent">
      <span style="<?= $current_status === 'Quotation Sent' ? 'background:#e6f0ff; padding:5px; border-radius:5px;' : '' ?>">
        <b>Quotation Sent:</b> 
       <img src="lg.sandglass-time-loading-gif.gif" style="height:20px; vertical-align:middle;" /> 
        <span style="color:blue;"><?= $leads['quotation_count'] ?></span>
      </span>
    </a>

  </div>
</div>

<?php }if (!empty($status) && !empty($month)) {

if (!empty($_GET['month'])) {
        $month = (int) $_GET['month'];
        if (strtolower($status) == 'closed') {
            $filters[] = "MONTH(update_date) = $month";
        } elseif (strtolower($status) == 'lost') {
            $filters[] = "MONTH(update_date) = $month";
        } elseif (strtolower($status) == 'quotation sent') {
            $filters[] = "MONTH(update_date) = $month";
        } elseif (strtolower($status) == 'lead') {
            $filters[] = "MONTH(update_date) = $month";
        }
    }
	
	$where_sql = '';
    if ($filters) {
        $where_sql = "WHERE " . implode(" AND ", $filters);
    }
        // === Case 1: lead_owner is given → show that designer's data ===
        $user_sql = "SELECT user_id FROM mst_users WHERE name = ?";
        $stmt = $conn->prepare($user_sql);
        $stmt->bind_param("s", $lead_owner);
        $stmt->execute();
        $user_result = $stmt->get_result();

        // === Case 2: Only status given → show global stats (all designers) ===
        $lead_sql = "
            SELECT 
                SUM(status = 'Closed')          AS closed_count,
                SUM(status = 'Lost')            AS lost_count,
                SUM(status = 'Lead')            AS open_count,
                SUM(status = 'Quotation Sent')  AS quotation_count
            FROM customer_leads $where_sql
        ";
        $lead_result = $conn->query($lead_sql);
        $leads = $lead_result->fetch_assoc();

        $customer_sql = "SELECT COUNT(*) as total_customers FROM customer_leads";
        $customer_result = $conn->query($customer_sql);
        $customer_data = $customer_result->fetch_assoc();
        $total_customers = $customer_data['total_customers'];
    $current_status = strtolower($status);
?>

<!-- HTML Card -->
<div class="card border-dark border-2 mb-4">
  <div class="card-body" style="font-size: 18px; display: flex; align-items: center; flex-wrap: wrap; gap: 20px;">
    <?php
// Map month numbers to names
$month_names = [
    1 => 'January', 2 => 'February', 3 => 'March', 4 => 'April',
    5 => 'May', 6 => 'June', 7 => 'July', 8 => 'August',
    9 => 'September', 10 => 'October', 11 => 'November', 12 => 'December'
];

// Get month number from GET parameter
$month_num = !empty($_GET['month']) ? (int)$_GET['month'] : 0;
$month_name = $month_names[$month_num] ?? '';

// Example: count leads for that month
$month_leads = 0;
if ($month_num > 0) {
    $sql = "SELECT COUNT(*) as count_leads 
            FROM customer_leads 
            WHERE MONTH(date) = $month_num";
    $result = $conn->query($sql);
    $data = $result->fetch_assoc();
    $month_leads = $data['count_leads'] ?? 0;
}
?><span><b>Activity Done on the month <?= htmlspecialchars($month_name) ?>:</b> 
    
</span>

    <a href="report1_admin.php?<?= !empty($month) ? 'month='.urlencode($month).'&' : '' ?>status=Closed">
	<span style="<?= $current_status === 'closed' ? 'background:#d4edda; padding:5px; border-radius:5px;' : '' ?>">
      <span><b>Win:</b> <img src="thumbs_up_sign_256_1.gif" style="height:20px; vertical-align:middle;" /> 
      <span style="color:green;"><?= $leads['closed_count'] ?></span></span>
	  </span>
    </a>

    <a href="report1_admin.php?<?= !empty($month) ? 'month='.urlencode($month).'&' : '' ?>status=Lost">
	<span style="<?= $current_status === 'lost' ? 'background:#f8d7da; padding:5px; border-radius:5px;' : '' ?>">
      <span><b>Lost:</b> <img src="tenor.gif" style="height:20px; vertical-align:middle;" /> 
      <span style="color:red;"><?= $leads['lost_count'] ?></span></span>
	  </span>
    </a>

    <a href="report1_admin.php?<?= !empty($month) ? 'month='.urlencode($month).'&' : '' ?>status=Lead">
	<span style="<?= $current_status === 'lead' ? 'background:#fff3cd; padding:5px; border-radius:5px;' : '' ?>">
      <span><b>Lead:</b> <img src="lg.sandglass-time-loading-gif.gif" style="height:20px; vertical-align:middle;" /> 
      <span style="color:red;"><?= $leads['open_count'] ?></span></span></span>
    </a>

    <a href="report1_admin.php?<?= !empty($month) ? 'month='.urlencode($month).'&' : '' ?>status=Quotation Sent">
	<span style="<?= $current_status === 'quotation sent' ? 'background:#cce5ff; padding:5px; border-radius:5px;' : '' ?>">
      <span><b>Quotation Sent:</b> <img src="lg.sandglass-time-loading-gif.gif" style="height:20px; vertical-align:middle;" /> 
      <span style="color:blue;"><?= $leads['quotation_count'] ?></span></span></span>
    </a>

  </div>
</div>
<?php 
} else {
	$branch = isset($_GET['branch']) ? urldecode($_GET['branch']) : '';

if (!empty($branch)) {

    // --- Build branch condition ---
    if ($branch === "Unknown") {
        $branch_condition = "(Branch IS NULL OR Branch = '')";
    } else {
        $branch_condition = "Branch = ?";
    }

    // 1. Get counts by status
    $lead_sql = "
        SELECT 
            SUM(status = 'Closed') AS closed_count,
            SUM(status = 'Lost')   AS lost_count,
            SUM(status = 'Lead')            AS open_count,
            SUM(status = 'Quotation Sent')  AS quotation_count
        FROM customer_leads 
        WHERE $branch_condition
    ";

    $stmt = $conn->prepare($lead_sql);

    if ($branch !== "Unknown") {
        $stmt->bind_param("s", $branch);
    }

    $stmt->execute();
    $lead_result = $stmt->get_result();
    $leads = $lead_result->fetch_assoc();

    // 2. Get total leads for branch
    $customer_sql = "
        SELECT COUNT(*) as total_customers 
        FROM customer_leads 
        WHERE $branch_condition
    ";

    $stmt2 = $conn->prepare($customer_sql);

    if ($branch !== "Unknown") {
        $stmt2->bind_param("s", $branch);
    }

    $stmt2->execute();
    $customer_result = $stmt2->get_result();
    $customer_data   = $customer_result->fetch_assoc();
    $total_customers = $customer_data['total_customers'];
?>
<?php
$current_status = $_GET['status'] ?? ''; // Get current status from URL
?>

  <div class="card border-dark border-2 mb-4">

    <div class="card-body" style="font-size: 18px; display: flex; align-items: center; flex-wrap: wrap; gap: 20px;">
	
        <span><b>No Of Customer:</b> 
            <span style="color:red;"><?= $total_customers ?></span>
        </span>

        <a href="report1_admin.php?<?= !empty($branch) ? 'branch='.urlencode($branch).'&' : '' ?>status=Closed">
	<span style="<?= $current_status === 'Closed' ? 'background:#d4edda; padding:5px; border-radius:5px;' : '' ?>">
      <span><b>Win:</b> <img src="thumbs_up_sign_256_1.gif" style="height:20px; vertical-align:middle;" /> 
      <span style="color:green;"><?= $leads['closed_count'] ?></span></span>
	  </span>
    </a>

    <a href="report1_admin.php?<?= !empty($branch) ? 'branch='.urlencode($branch).'&' : '' ?>status=Lost">
	<span style="<?= $current_status === 'Lost' ? 'background:#f8d7da; padding:5px; border-radius:5px;' : '' ?>">
        <b>Lost:</b> 
      <span><b>Lost:</b> <img src="tenor.gif" style="height:20px; vertical-align:middle;" /> 
      <span style="color:red;"><?= $leads['lost_count'] ?></span></span>
	  </span>
    </a>

    <a href="report1_admin.php?<?= !empty($branch) ? 'branch='.urlencode($branch).'&' : '' ?>status=Lead">
	<span style="<?= $current_status === 'Lead' ? 'background:#fff3cd; padding:5px; border-radius:5px;' : '' ?>">
      <span><b>Lead:</b> <img src="lg.sandglass-time-loading-gif.gif" style="height:20px; vertical-align:middle;" /> 
      <span style="color:red;"><?= $leads['open_count'] ?></span></span></span>
    </a>

    <a href="report1_admin.php?<?= !empty($branch) ? 'branch='.urlencode($branch).'&' : '' ?>status=Quotation Sent">
	<span style="<?= $current_status === 'Quotation Sent' ? 'background:#cce5ff; padding:5px; border-radius:5px;' : '' ?>">
      <span><b>Quotation Sent:</b> <img src="lg.sandglass-time-loading-gif.gif" style="height:20px; vertical-align:middle;" /> 
      <span style="color:blue;"><?= $leads['quotation_count'] ?></span></span></span>
    </a>

    </div>
	</div>
	<?php } else{

      //  echo "<div class='alert alert-danger'>No user found for: <b>$lead_owner</b></div>";

    }

}
if (!empty($lead_owner)) {
    // Get user_id for the lead_owner
    $stmt = $conn->prepare("SELECT user_id FROM mst_users WHERE name = ?");
    $stmt->bind_param("s", $lead_owner);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($user = $result->fetch_assoc()) {
        $filters[] = "assign_to = " . intval($user['user_id']);
    }
}

if (!empty($status)) {
    $filters[] = "status = '" . $conn->real_escape_string($status) . "'";
}

if (!empty($month)) {
    $filters[] = "MONTH(date) = " . intval($month);
}

if (!empty($branch)) {
    $filters[] = "Branch = '" . $conn->real_escape_string($branch) . "'";
}




$noFilters = empty($lead_owner) && empty($status) && empty($month) && empty($branch);

if ($noFilters) {
    // --- Build WHERE clause (empty) ---
    $whereClause = "";

    // --- Get counts for all records ---
    $count_sql = "
        SELECT
            SUM(status = 'Closed') AS closed_count,
            SUM(status = 'Lost') AS lost_count,
            SUM(status = 'Lead') AS open_count,
            SUM(status = 'Quotation Sent') AS quotation_count,
            COUNT(*) AS total_customers
        FROM customer_leads
    ";
    $count_result = $conn->query($count_sql);
    $leads = $count_result->fetch_assoc();
    $total_customers = $leads['total_customers'];
    $current_status = ''; // no status selected
    ?>

    <!-- Summary Card (only for no filters) -->
    <div class="card border-dark border-2 mb-4">
      <div class="card-body" style="font-size: 18px; display: flex; align-items: center; flex-wrap: wrap; gap: 20px;">
       <a href="report1_admin.php"> <span style="background:#ffe6e6; padding:5px; border-radius:5px;"><b>No Of Customer:</b> <span style="color:red;"><?= $total_customers ?></span></span></a>

        <!-- Win -->
        <a href="report1_admin.php?status=Closed">
          <span style="<?= $current_status === 'Closed' ? 'background:#e6ffe6; padding:5px; border-radius:5px;' : '' ?>">
            <b>Win:</b> 
            <img src="thumbs_up_sign_256_1.gif" style="height:20px; vertical-align:middle;" /> 
            <span style="color:green;"><?= $leads['closed_count'] ?></span>
          </span>
        </a>

        <!-- Lost -->
        <a href="report1_admin.php?status=Lost">
          <span style="<?= $current_status === 'Lost' ? 'background:#ffe6e6; padding:5px; border-radius:5px;' : '' ?>">
            <b>Lost:</b> 
            <img src="tenor.gif" style="height:20px; vertical-align:middle;" /> 
            <span style="color:red;"><?= $leads['lost_count'] ?></span>
          </span>
        </a>

        <!-- Lead -->
        <a href="report1_admin.php?status=Lead">
          <span style="<?= $current_status === 'Lead' ? 'background:#fff3cd; padding:5px; border-radius:5px;' : '' ?>">
            <b>Lead:</b> 
            <img src="lg.sandglass-time-loading-gif.gif" style="height:20px; vertical-align:middle;" /> 
            <span style="color:orange;"><?= $leads['open_count'] ?></span>
          </span>
        </a>

        <!-- Quotation Sent -->
        <a href="report1_admin.php?status=Quotation%20Sent">
          <span style="<?= $current_status === 'Quotation Sent' ? 'background:#e6f0ff; padding:5px; border-radius:5px;' : '' ?>">
            <b>Quotation Sent:</b> 
            <img src="lg.sandglass-time-loading-gif.gif" style="height:20px; vertical-align:middle;" /> 
            <span style="color:blue;"><?= $leads['quotation_count'] ?></span>
          </span>
        </a>
      </div>
    </div>

<?php } // end if no filters ?>




</th>

</tr>

<tr>

    <th>#</th>

    <th>Client Name</th>

    <th width="100">Address</th>

    <th>Via Ref</th>

    <th>Lead Date.</th>

    <th>Designer</th>

    <th>Activity Date</th>

    <th>Step</th>

    <th width="150">Remarks</th>
	<th>Payment</th>

    <th>Order ID</th>

    <th>Production</th>

    <th>Delivery</th>

    <th>Installation</th>

    <th>WCC</th>

</tr>

</thead>

<tbody>

<?php
$i=1;		
$filters = [];

// --- Customer Name Filter ---
if (!empty($_GET['customer_name'])) {
    $customer_name = mysqli_real_escape_string($conn, $_GET['customer_name']);
    $filters[] = "customer_name LIKE '%$customer_name%'";
}

// --- Lead Owner Filter ---
if (!empty($_GET['lead_owner'])) {
    $lead_owner = mysqli_real_escape_string($conn, $_GET['lead_owner']);
    // Get user IDs matching the lead_owner name
    $userResult = mysqli_query($conn, "SELECT user_id FROM mst_users WHERE name LIKE '%$lead_owner%'");
    $userIds = [];
    while ($u = mysqli_fetch_assoc($userResult)) {
        $userIds[] = "'" . $u['user_id'] . "'";
    }
    if (!empty($userIds)) {
        $filters[] = "assign_to IN (" . implode(",", $userIds) . ")";
    }
}

// --- User ID Filter ---
if (!empty($_GET['user_id'])) {
    $user_id = intval($_GET['user_id']);
    $filters[] = "entry_by = $user_id";
}

// --- Date Range Filter ---
if (!empty($_GET['from_date']) && !empty($_GET['to_date'])) {
    $from = mysqli_real_escape_string($conn, $_GET['from_date']);
    $to   = mysqli_real_escape_string($conn, $_GET['to_date']);
    $filters[] = "date BETWEEN '$from' AND '$to'";
}

// --- Enquiry Priority ---
if (!empty($_GET['enquiry_priority'])) {
    $priority = mysqli_real_escape_string($conn, $_GET['enquiry_priority']);
    $filters[] = "LOWER(enquiry_priority) = LOWER('$priority')";
}

// --- Status & Month Filter ---
if (!empty($_GET['status'])) {
    $status = mysqli_real_escape_string($conn, $_GET['status']);
    $filters[] = "LOWER(status) = LOWER('$status')";

    if (!empty($_GET['month'])) {
        $month = (int) $_GET['month'];
        if (strtolower($status) == 'closed') {
            $filters[] = "MONTH(update_date) = $month";
        } elseif (strtolower($status) == 'lost') {
            $filters[] = "MONTH(update_date) = $month";
        } elseif (strtolower($status) == 'quotation sent') {
            $filters[] = "MONTH(update_date) = $month";
        } elseif (strtolower($status) == 'lead') {
            $filters[] = "MONTH(update_date) = $month";
        }
    }
}

// --- Enquiry Status ---
if (!empty($_GET['enquiry_status'])) {
    $enquiry_status = mysqli_real_escape_string($conn, $_GET['enquiry_status']);
    $filters[] = "enquiry_status = '$enquiry_status'";
}

// --- Branch Filter ---
if (!empty($_GET['branch'])) {
    if ($_GET['branch'] === 'Unknown') {
        $filters[] = "(Branch IS NULL OR Branch = '')";
    } else {
        $branch = mysqli_real_escape_string($conn, $_GET['branch']);
        $filters[] = "Branch = '$branch'";
    }
}

// --- Architect Name Filter ---
if (!empty($_GET['architech_name'])) {
    $architech_name = mysqli_real_escape_string($conn, $_GET['architech_name']);
    $filters[] = "architech_name LIKE '%$architech_name%'";
}

// --- Ref Name Filter ---
if (!empty($_GET['ref_name'])) {
    $ref_name = mysqli_real_escape_string($conn, $_GET['ref_name']);
    $filters[] = "ref_name LIKE '%$ref_name%'";
}

// --- Always filter by user login type if needed ---
if ($login_type == 'user' && $_REQUEST['back']=='user') {
    $filters[] = "assign_to = '$user_id_self'";
}

// --- Build final WHERE clause ---
$whereClause = !empty($filters) ? "WHERE " . implode(" AND ", $filters) : "";

// --- Final Query ---
$query = "SELECT * FROM customer_leads $whereClause ORDER BY lead_id DESC";

//echo $query;

   // $query = "SELECT * FROM customer_leads ORDER BY lead_id DESC";
          $result = mysqli_query($conn, $query);
          while ($row = mysqli_fetch_assoc($result)) {

		  $lead_id = $row['lead_id'];
            $requirements = explode(",", $row['requirement']);
            $requirementList = "<ul>";
            foreach ($requirements as $req) {
              $requirementList .= "<li>" . htmlspecialchars(trim($req)) . "</li>";
            }
            $requirementList .= "</ul>";

            $leadTemp = ucfirst(strtolower($row['enquiry_priority']));
            switch ($leadTemp) {
    case 'Hot':
        $leadBadge = "<span class='badge badge-hot badge-status'>Hot</span>";
        break;
    case 'Warm':
        $leadBadge = "<span class='badge badge-warm badge-status'>Warm</span>";
        break;
    case 'Cold':
        $leadBadge = "<span class='badge badge-cold badge-status'>Cold</span>";
        break;
    default:
        $leadBadge = "<span class='badge badge-cold1 badge-status'>N/A</span>";
        break;
}           $enquiry_status = ucwords(str_replace('_', ' ', $row['enquiry_status']));

		  $step = $row['step'];

		  $received_amt = $row['received_amt'];

		  $order_no = $row['order_no'];

		  $lead_id = $row['lead_id'];if($step=='4') {

if($received_amt==''){

$enquiry_status = 'Quote Approve waiting for Token';
}

if($received_amt!='' and $order_no==''){
$enquiry_status ='Waiting for 50% Advance ';
}

if($received_amt!='' and $order_no!=''){
$enquiry_status = 'Final Sign Off Pending';

//  $page='lead_quote_PPT_upload_approve.php';
}
}
switch ($enquiry_status) {
    case 'In Discussion':
        $statusColor = 'warning';
        break;
    case 'Quote Submitted':
        $statusColor = 'primary';
        break;
    case 'Order Closed':
        $statusColor = 'success';
        break;
    case 'Quote Request':
        $statusColor = 'danger';
        break;
		 case 'Payment Received':
        $statusColor = 'info';
        break;
    default:
        $statusColor = 'dark'; // fallback for unexpected values
        break;
}

$statusBadge = "<span class='badge bg-$statusColor badge-status'>" . htmlspecialchars($enquiry_status) . "</span>";

           // $stageName = ucwords(str_replace('_', ' ', $row['lead_status']));

		   

		   

		   

			$stageName =$row['last_conversation_details'];

			

if($stageName=='') {

			$stageName =$row['remark'];
}

            $stageBadge = "$stageName";
if($row['qtn_date']!='') {

            $qtn_date = date('d/m/Y', strtotime($row['qtn_date']));

}else {

$qtn_date='';

}

            $formattedDate = date('d/m/Y', strtotime($row['date']));
            $monthName = date('M', strtotime($row['date']));
			$assign_to = $row['assign_to'];
			$segment1 = $row['segment'];
			$Branch=$row['Branch'];
			$querytl = "select * from  mst_users where user_id='$assign_to'";
									$resulttl = mysqli_query($conn,$querytl);
									while($row1=mysqli_fetch_array($resulttl))
									{
									$first_name09 = $row1['name'];
									}

				$querytl = "select * from  segment where segment='$segment1'";
									$resulttl = mysqli_query($conn,$querytl);
									while($row2=mysqli_fetch_array($resulttl))
									{
									$segments = $row2['segment'];
									}

$requirements = explode(',', $row['requirement']); // split by comma           

echo "<tr>";

echo "<td>{$i}</td>";
// Customer Name (link only if not 'user' type)    
echo "<td>{$row['customer_name']} <br>{$row['project_name']}</td>";

// Mobile Number
// Address

echo "<td>{$row['address']}</td>";
// Via Ref (architech, ref, exhibition, etc.)

 $parts = [];
    if (!empty($row['architect_firm_name']) && $row['architect_firm_name']!='NA') { $parts[] = $row['architect_firm_name']; }
    if (!empty($row['architech_name'])) { $parts[] = $row['architech_name']; }
    if (!empty($row['exhibition_name'])) { $parts[] = $row['exhibition_name']; }
    if (!empty($row['ref_name'])) { $parts[] = $row['ref_name']; }
    if (!empty($row['social_media_platform'])) { $parts[] = $row['social_media_platform']; }
    if (!empty($row['builder_name'])) { $parts[] = $row['builder_name']; }
    if (!empty($row['builder_contact_person'])) { $parts[] = $row['builder_contact_person']; }
    $infoString = implode(' / ', $parts);
    echo "<td>$infoString</td>";
$formattedDate = date('d/m/Y', strtotime($row['date']));

echo "<td>{$formattedDate}</td>";// Entry By

$entryById = $row['entry_by'];

$entryByName = mysqli_fetch_assoc(mysqli_query($conn, "SELECT name FROM mst_users WHERE user_id = '$assign_to'"))['name'] ?? 'N/A';

echo "<td>{$entryByName}</td>";
// Last Date (last updated date or similar)

$lastDate = $row['update_date'] ?? '';

if ($lastDate != '') {

    $lastDateFormatted = date('d/m/Y', strtotime($lastDate));

    echo "<td>{$lastDateFormatted}</td>";

} else {

    echo "<td></td>";

}
// Step

$status = $row['status'] ?? '';

$statusDisplay = '';
switch ($status) {

    case 'Closed':

        $statusDisplay = "<p class='mb-1'><img src='thumbs_up_sign_256_1.gif' class='status-icon' /> <span class='status-label'>Closed</span></p>";

        break;

    case 'Lost':

        $statusDisplay = "<p class='mb-1'><img src='tenor.gif' class='status-icon' /> <span class='status-label'>Lost</span></p>";

        break;

    case 'Lead':

        $statusDisplay = "<p class='mb-1'><img src='lg.sandglass-time-loading-gif.gif' class='status-icon' /> <span class='status-label'>Lead</span></p>";

        break;
		 case 'Quotation Sent':

        $statusDisplay = "<p class='mb-1'><img src='lg.sandglass-time-loading-gif.gif' class='status-icon' /> <span class='status-label'>Quotation Sent</span></p>";

        break;

    default:

        $statusDisplay = "<span class='text-muted'>N/A</span>";

        break;

}
echo "<td>$statusDisplay</td>";// Remarks

$remark = $row['last_conversation_details'] ?: $row['remark'];

echo "<td style='white-space: normal; max-width: 200px;'>

        <div id='remarkCell{$lead_id}'>

            {$remark}

        </div>

      </td>";
// Order


$payment_date = $row['payment_date'] ?? '';

if ($payment_date != '') {

    $lastDateFormatted02 = date('d/m/Y', strtotime($payment_date));
    $lastDateFormatted03 = date('M', strtotime($payment_date));

    echo "<td>{$lastDateFormatted03}";
	echo '<br>';
	echo "{$lastDateFormatted02}</td>";

} else {

    echo "<td></td>";

}

echo "<td>{$row['order_no']}</td>";
// Production (assuming a field like production_status)

echo "<td>{$row['production_status']}</td>";
// Delivery

echo "<td>{$row['delivery_status']}</td>";
// Installation

echo "<td>{$row['installation_status']}</td>";
// WCC (Work Completion Certificate)

echo "<td>{$row['wcc_status']}</td>";
echo "</tr>";
			

			?>

<div class="modal fade" id="remarkModal<?= $lead_id ?>" tabindex="-1" aria-labelledby="remarkModalLabel<?= $lead_id ?>" aria-hidden="true">

<div class="modal-dialog">

<form method="POST" action="save_remark.php" class="remark-form">

<input type="hidden" name="reportno" value="1">

<div class="modal-content">

<div class="modal-header">

<h5 class="modal-title" id="remarkModalLabel<?= $lead_id ?>">Add Remark for Lead #

<?= $lead_id ?>

</h5>

<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>

</div>

<div class="modal-body">

<input type="hidden" name="lead_id" value="<?= $lead_id ?>">

<div class="mb-3">

<label for="remarkText<?= $lead_id ?>" class="form-label">Remark</label>

<textarea class="form-control" name="remark" id="remarkText<?= $lead_id ?>" rows="3" required></textarea>

</div>

</div>

<div class="modal-footer">

<button type="submit" class="btn btn-success">Save Remark</button>

<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

</div>

</div>

</form>

</div>

</div>

<?php 

$i++;

          }
          ?>

</tbody>

</table>

</div>

</div>

<script>
$('.remark-form').on('submit', function(e) {
  e.preventDefault();

  const form = $(this);
  const formData = form.serialize();
  const leadId = form.find('input[name="lead_id"]').val();

  $.ajax({
    type: 'POST',
    url: form.attr('action'),
    data: formData,
    dataType: 'json', // 👈 Ensure this!
    success: function(response) {
  if (response.status === 'success') {
    alert(response.message);
    form.closest('.modal').modal('hide');

    const leadId = form.find('input[name="lead_id"]').val();
    const targetCell = $('#remarkCell' + leadId);

    // Rebuild the button (you can customize it as needed)
    const remarkButton = '<button class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#remarkModal' + leadId + '">Remark</button>';

    // Escape remark safely
    const escapedRemark = $('<div>').text(response.remark).html();

    // Set new HTML inside the remarkCell div
    targetCell.html(
      remarkButton + '<br>' +
      '<small>Last conversation: <span id="lastRemark' + leadId + '">' + escapedRemark + '</span></small>'
    );
  } else {
    alert('Unexpected server response');
  }setTimeout(function() {
      location.reload();
    }, 500); // 2000ms = 2 seconds

}
,
    error: function(xhr) {
      alert('Error saving remark');
      console.log(xhr.responseText);
    }
  });
});
</script>
<style>
.dataTables_filter {
    margin-bottom: 5px;
	 margin-top: 5px; 
	  margin-left: 15px; /* spacing below search */
}

.dataTables_filter label {
    font-weight: bold;
    margin-right: 10px;
}

.dataTables_filter input {
    border-radius: 8px;
    padding: 6px 12px;
    border: 1px solid #ccc;
    width: 250px;        /* wider input */
}
</style>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
$(document).ready(function() {
    // Ensure table has id
    var $table = $('#leadsTable');
    if ($table.length === 0) {
        var firstTable = $('.table').first();
        if (firstTable.length) firstTable.attr('id', 'leadsTable');
        $table = $('#leadsTable');
    }
    if (!$table.length) {
        console.error('leadsTable not found in DOM.');
        return;
    }

    var $theadRows = $table.find('thead tr');

    // Find the 'title' header row (the one with the real column headers)
    var $titleRow = $theadRows.filter(function() {
        // prefer rows with multiple THs and no colspan THs
        return $(this).find('th').length > 1 && $(this).find('th[colspan]').length === 0;
    }).first();

    // fallback: first row with >1 th
    if (!$titleRow.length) {
        $titleRow = $theadRows.filter(function(){ return $(this).find('th').length > 1; }).first();
    }

    if (!$titleRow.length) {
        console.error('Could not find header title row. Ensure the table has a header row with column ths.');
        return;
    }

    var columnCount = $titleRow.find('th').length;

    // Auto-fix top single-TH (info card) colspan if present
    var $topSingleThRow = $theadRows.filter(function() {
        return $(this).find('th').length === 1 && $(this).find('th[colspan]').length;
    }).first();

    if ($topSingleThRow.length) {
        $topSingleThRow.find('th').attr('colspan', columnCount);
    }

    // Add column filter row (only if not already present)
    if ($table.find('thead tr.filter-row').length === 0) {
        var $filterRow = $('<tr class="filter-row"></tr>');
        for (var i = 0; i < columnCount; i++) {
            if (i === 0) {
                $filterRow.append('<th></th>'); // usually first column index column (no filter)
            } else {
                var headerText = $titleRow.find('th').eq(i).text().trim();
                var placeholder = headerText ? 'Search ' + headerText : 'Search';
                $filterRow.append('<th><input type="text" class="form-control form-control-sm column-filter" placeholder="' + placeholder + '" data-col="' + i + '"></th>');
            }
        }
        $titleRow.after($filterRow);
    }

    // Initialize DataTable
    var dataTable;
    try {
        dataTable = $table.DataTable({
            orderCellsTop: true,
            fixedHeader: true,
            paging: false,
            info: false,
            searching: true,
            // show global search ('f') in a top container, then processing('r') and table('t')
           dom: '<"row mb-3"<"col-md-6"f>>rt',
            autoWidth: false,
            // If you want, explicitly declare column count to be safe:
            columns: (function(){
                var cols = [];
                for (var j=0;j<columnCount;j++) cols.push({});
                return cols;
            })()
        });
    } catch (e) {
        console.error('DataTable init error:', e);
        return;
    }

    // If you have a custom input (#globalSearch) connect it (optional)
    $('#globalSearch').off('keyup.dtGlobal').on('keyup.dtGlobal', function() {
        dataTable.search(this.value).draw();
    });

    // Debounce helper for column filters
    function debounce(fn, delay) {
        var timer = null;
        return function() {
            var context = this, args = arguments;
            clearTimeout(timer);
            timer = setTimeout(function() {
                fn.apply(context, args);
            }, delay || 300);
        };
    }

    // Column filter handlers
    $table.find('thead').on('keyup change', '.column-filter', debounce(function() {
        var $inp = $(this);
        var colIndex = parseInt($inp.data('col'), 10);
        if (isNaN(colIndex)) return;
        dataTable.column(colIndex).search($inp.val()).draw();
    }, 200));
});
</script>

</html>

