<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Login | Kitchen Studio CRM</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    html, body {
      height: 100%;
      margin: 0;
      font-family: 'Segoe UI', sans-serif;
      background: linear-gradient(-45deg, #ff9a9e, #fad0c4, #fad0c4, #a1c4fd);
      background-size: 400% 400%;
      animation: gradient 15s ease infinite;
    }

    @keyframes gradient {
      0% { background-position: 0% 50%; }
      50% { background-position: 100% 50%; }
      100% { background-position: 0% 50%; }
    }

    .glass-card {
      background: rgba(255, 255, 255, 0.15);
      border-radius: 16px;
      backdrop-filter: blur(12px);
      -webkit-backdrop-filter: blur(12px);
      box-shadow: 0 8px 32px rgba(0, 0, 0, 0.2);
      border: 1px solid rgba(255, 255, 255, 0.3);
      padding: 2.5rem;
      color: white;
      width: 100%;
      max-width: 420px;
      animation: fadeIn 1s ease-in-out;
    }

    @keyframes fadeIn {
      0% { opacity: 0; transform: translateY(20px); }
      100% { opacity: 1; transform: translateY(0); }
    }

    .form-control {
      background: rgba(255, 255, 255, 0.2);
      border: none;
      color: #fff;
    }

    .form-control::placeholder {
      color: #ddd;
    }

    .form-control:focus {
      box-shadow: none;
      background: rgba(255, 255, 255, 0.3);
      color: #fff;
    }

    .btn-glow {
      background: #fff;
      color: #000;
      font-weight: bold;
      border-radius: 8px;
      transition: all 0.3s ease;
    }

    .btn-glow:hover {
      box-shadow: 0 0 15px rgba(255, 255, 255, 0.8);
    }

    a {
      color: #fff;
    }

    a:hover {
      text-decoration: underline;
    }

    .logo {
      width: 150px;
    }

    .footer {
      font-size: 0.85rem;
      opacity: 0.7;
      margin-top: 1rem;
    }
  </style>
</head>
<body>
  <div class="d-flex justify-content-center align-items-center vh-100">
    <div class="glass-card text-center">
      <img src="assets/img/logo.jpg" alt="Logo" class="logo mb-3">
      <h3 class="mb-4">Welcome to Kitchen Studio</h3>
      <form action="check.php" method="post">
        <div class="mb-3 text-start">
          <label class="form-label">Username</label>
          <input type="text" class="form-control" name="username" placeholder="Enter your username">
        </div>
        <div class="mb-3 text-start">
          <label class="form-label">Password</label>
          <input type="password" class="form-control" name="password" placeholder="Enter your password">
        </div>
        <div class="d-flex justify-content-end mb-3">
          <a href="forgot-password.html">Forgot Password?</a>
        </div>
        <button type="submit" class="btn btn-glow w-100">Log In</button>
      </form>
      <div class="footer mt-4">
        &copy; 2025 Kitchen Studio
      </div>
    </div>
  </div>
</body>
</html>
