<?php
session_start();
include 'connection.php';
date_default_timezone_set('Asia/Calcutta');

if (!isset($_SESSION['is_logged_in'])) {
    header("Location: login.php");
    exit();
}

$login_name = $_SESSION["LOGIN_NAME"];
$login_pass = $_SESSION["EMPLOYEE_PASSWORD"];

$querylogin = "SELECT * FROM mst_users WHERE user_name = '$login_name' AND password = '$login_pass'";
$resultlogin = mysqli_query($conn, $querylogin);
$user = mysqli_fetch_assoc($resultlogin);

$name        = $user['name'];
$user_id     = $user['user_id'];
$first_name  = $user['name'];

if ($_SERVER["REQUEST_METHOD"] == "POST") {
   // 1. Collect POST data
$order_no          = $_REQUEST['order_no'] ?? ''; // TODO: Make this dynamic
$order_date        = $_REQUEST['order_date'] ?? '';
$customer_name     = $_POST['customer_name'] ?? '';
$order_type        = $_POST['order_type'] ?? '';
$entry_by          = $_POST['entry_by'] ?? $user_id;
$lead_id           = $_POST['lead_id'] ?? 0;
$lead_no           = $_POST['lead_no'] ?? '';
$ref_date          = $_POST['ref_date'] ?? '';
$reference_no      = $_POST['reference_no'] ?? '';
$call_follow_up_id = $_POST['call_follow_up_id'] ?? 0;
$step              = $_POST['step'] ?? 1;
$jcno              = $order_no;

$today       = date('Y-m-d H:i:s');
$entry_date  = date('Y-m-d');
$entry_time  = date('H:i:s');

// 2. Fetch current stage
$stage_stmt = $conn->prepare("SELECT stage FROM Stage_master WHERE step = ?");
$stage_stmt->bind_param("i", $step);
$stage_stmt->execute();
$stage_result = $stage_stmt->get_result();
$stage_row = $stage_result->fetch_assoc();
$current_stage = $stage_row['stage'] ?? 'Unknown';
$stage_stmt->close();

// 3. Insert into job_order_history
$history_stmt = $conn->prepare("
    INSERT INTO job_order_history (jcno, stage, step, entry_by, entry_date, entry_time, status)
    VALUES (?, ?, ?, ?, ?, ?, ?)
");
$history_stmt->bind_param("ssissss", $jcno, $current_stage, $step, $entry_by, $entry_date, $entry_time, $current_stage);
$history_stmt->execute();
$history_stmt->close();

// 4. Get next stage and update Job_order_Status
$new_step = $step + 1;
$stage_stmt = $conn->prepare("SELECT stage FROM Stage_master WHERE step = ?");
$stage_stmt->bind_param("i", $new_step);
$stage_stmt->execute();
$stage_result = $stage_stmt->get_result();
$stage_row = $stage_result->fetch_assoc();
$new_stage = $stage_row['stage'] ?? '';
$stage_stmt->close();


// 5. Insert into order_form
$qryOrder = $conn->prepare("
    INSERT INTO order_form (
        order_no, order_date, customer_name, order_type,
        entry_by, entry_date, entry_time,
        lead_no, lead_id, call_follow_up_id, reference_no, ref_date
    ) VALUES (?, ?, ?, ?, ?, CURDATE(), CURTIME(), ?, ?, ?, ?, ?)
");

$qryOrder->bind_param(
    "ssssiissss",
    $order_no, $order_date, $customer_name, $order_type,
    $user_id, $lead_no, $lead_id, $call_follow_up_id, $reference_no, $ref_date
);

if ($qryOrder->execute()) {
    $order_id = $conn->insert_id;
	
	
$update_stmt = $conn->prepare("UPDATE Job_order_Status SET status = ?, step = ?, stage = ?, order_id = ? WHERE jcno = ?");
$update_stmt->bind_param("sisss", $new_stage, $new_step, $new_stage, $order_id, $jcno);
$update_stmt->execute();
$update_stmt->close();
	
	
$rows = $_POST['rows'] ?? [];


foreach ($rows as $index => $row) {
    if (!is_array($row)) continue;

    $product         = $row['product'] ?? '';
    $colour          = $row['colour'] ?? '';
    $width           = $row['width'] ?? '';
    $height          = $row['height'] ?? '';
	$sqft 			 = $row['sqft'] ?? '';
    $depth           = $row['depth'] ?? '';
    $qty             = (int)($row['qty'] ?? 1);
    $handle          = $row['handle'] ?? '';
    $remark          = $row['remark'] ?? '';
    $created_at           = date('Y-m-d H:i:s');
    $section         = $row['section_name'] ?? '';
    $brand           = $row['brand'] ?? '';
    $code            = $row['code'] ?? '';
    $unit            = $row['unit'] ?? '';
    $vendor          = $row['vendor'] ?? '';
    $thickness       = $row['thickness'] ?? '';
    $material        = $row['material'] ?? '';
    $finish          = $row['finish'] ?? '';
    $back_colour     = $row['back_colour'] ?? '';
    $grain_direction = $row['grain_direction'] ?? '';
    $confirm_date    = ''; // default blank
    $confirm_status  = ''; // default blank
    $ref_image       = '';

    // File upload handling (if image exists for this row)
    if (isset($_FILES['rows']['name'][$index]['file']) && $_FILES['rows']['error'][$index]['file'] === 0) {
        $filename  = basename($_FILES['rows']['name'][$index]['file']);
        $tmpname   = $_FILES['rows']['tmp_name'][$index]['file'];
        $targetDir = "uploads/order_files/";
        $newPath   = $targetDir . uniqid() . "_" . $filename;

        if (move_uploaded_file($tmpname, $newPath)) {
            $ref_image = $newPath;
        }
    }

     $sql = "
INSERT INTO `order_details` (
    `product`, `colour`, `width`, `height`, `sqft`, `depth`, `qty`, `handle`, `remark`, `created_at`,
    `order_id`, `order_no`, `order_date`, `customer_name`, `lead_id`, `section_name`,
    `brand`, `code`, `unit`, `vendor_name`, `entry_by`,
    `thickness`, `material`, `finish`, `back_colour`, `grain_direction`,
    `confirm_date`, `confirm_status`, `ref_image`
) VALUES (
    '$product', '$colour', '$width', '$height', '$sqft', '$depth', $qty, '$handle', '$remark', '$created_at',
    '$order_id', '$order_no', '$order_date', '$customer_name', '$lead_id', '$section',
    '$brand', '$code', '$unit', '$vendor', '$entry_by',
    '$thickness', '$material', '$finish', '$back_colour', '$grain_direction',
    '$confirm_date', '$confirm_status', '$ref_image'
)
";

// Debug SQL before executing
// echo $sql; exit;

if (!$conn->query($sql)) {
    die("Insert failed: " . $conn->error);
}

}



 json_encode(["success" => true, "message" => "Order successfully saved."]);

} else {
     json_encode(["success" => false, "message" => "Order form insert failed: " . $conn->error]);
}
}

//exit();
echo "<script>window.location.href='index_operation.php';</script>";

?>
