<?php
session_start();
include 'connection.php';

if (!isset($_SESSION['is_logged_in'])) {
    header("Location: login.php");
    exit();
}

header('Content-Type: application/json');

$querylogin = "SELECT * FROM mst_users WHERE user_name = ? AND password = ?";
$stmtLogin = $conn->prepare($querylogin);
$stmtLogin->bind_param("ss", $_SESSION["LOGIN_NAME"], $_SESSION["EMPLOYEE_PASSWORD"]);
$stmtLogin->execute();
$resultlogin = $stmtLogin->get_result();
$branch = '';
$user_id = '';

if ($row = $resultlogin->fetch_assoc()) {
    $branch = $row['branch'];
    $user_id = $row['user_id'];
}
$stmtLogin->close();

// Variables from session
$login_id = $_SESSION['user_id'] ?? $user_id;
$LOGIN_NAME = $_SESSION['username'] ?? $_SESSION['LOGIN_NAME'];
$today = date('Y-m-d');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $firm_id = isset($_POST['firm_id']) ? (int)$_POST['firm_id'] : 0;
    $architect_id = $_POST['architect_name'] ?? '';
    $new_architect_name = $_POST['new_architect_name'] ?? '';
    $architect_mobile_no = $_POST['architect_mobile_no'] ?? '';
    $followup_details = $_POST['followup_details'] ?? '';
    $next_reminder_date = $_POST['next_reminder_date'] ?? null;
    $next_reminder_time = $_POST['next_reminder_time'] ?? null;
    $followup_type = $_POST['followup_type'] ?? '';
    $call_followup_id = !empty($_POST['call_followup_id']) ? (int)$_POST['call_followup_id'] : null;

    // Additional values (e.g., hidden fields)
    $lead_no = $_POST['lead_no'] ?? '';
    $lead_id = $_POST['lead_id'] ?? '';
    $customer_id = $firm_id;
    $name = $architect_id;

    if (empty($firm_id) || (empty($architect_id) && empty($new_architect_name))) {
        echo json_encode(['status' => 'error', 'message' => 'Firm and Architect are required.']);
        exit;
    }

    // Fetch firm name
    $architech_company_name = '';
    $firmQuery = "SELECT firm_name FROM architectfirm_master WHERE firm_id = ?";
    $stmt = $conn->prepare($firmQuery);
    $stmt->bind_param("i", $firm_id);
    $stmt->execute();
    $firmResult = $stmt->get_result();
    if ($firmRow = $firmResult->fetch_assoc()) {
        $architech_company_name = $firmRow['firm_name'];
    }
    $stmt->close();

    // Get or insert architect
    $architect_name = '';
    if ($architect_id === 'other') {
        $insertQuery = "INSERT INTO architect_master (architect_name, firm_id, mobile_no, firm_name) VALUES (?, ?, ?, ?)";
        $stmt = $conn->prepare($insertQuery);
        $stmt->bind_param("siss", $new_architect_name, $firm_id, $architect_mobile_no, $architech_company_name);
        $stmt->execute();
        $architect_id_db = $conn->insert_id;
        $architect_name = $new_architect_name;
        $stmt->close();
    } else {
        $architect_id_db = (int)$architect_id;
        $archQuery = "SELECT architect_name FROM architect_master WHERE architect_id = ?";
        $stmt = $conn->prepare($archQuery);
        $stmt->bind_param("i", $architect_id_db);
        $stmt->execute();
        $archResult = $stmt->get_result();
        if ($archRow = $archResult->fetch_assoc()) {
            $architect_name = $archRow['architect_name'];
        }
        $stmt->close();
    }

    // Insert into call_follow_up if not already exists
    if (!$call_followup_id) {
        $step = '1';
        $step_name = 'Lead_generate';
        $qrycall = "INSERT INTO call_follow_up (
            customer_id, customer_name, lead_no, step, step_name, Branch, lead_id, login_id, LOGIN_NAME, update_date
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

        $stmt_call = $conn->prepare($qrycall);
        $stmt_call->bind_param(
            "ssssssssss",
            $customer_id,
            $architect_name,
            $lead_no,
            $step,
            $followup_type,  // used in place of $step_name
            $branch,
            $lead_id,
            $login_id,
            $LOGIN_NAME,
            $today
        );

        if ($stmt_call->execute()) {
            $call_followup_id = $conn->insert_id;
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Call follow-up creation failed: ' . $stmt_call->error]);
            exit;
        }

        $stmt_call->close();
    }

    // Insert into architect_followup
    $insertFollowup = "INSERT INTO architect_followup (
        call_followup_id, firm_id, architect_id, new_architect_name, architect_mobile_no,
        followup_details, next_reminder_date, next_reminder_time, followup_type, architect_name, entry_by
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    $stmt = $conn->prepare($insertFollowup);
    if (!$stmt) {
        echo json_encode(['status' => 'error', 'message' => 'Prepare failed: ' . $conn->error]);
        exit;
    }

    $stmt->bind_param(
        "issssssssss",
        $call_followup_id,
        $firm_id,
        $architect_id_db,
        $new_architect_name,
        $architect_mobile_no,
        $followup_details,
        $next_reminder_date,
        $next_reminder_time,
        $followup_type,
        $architect_name,
		$login_id
    );

    if ($stmt->execute()) {
        echo json_encode([
            'status' => 'success',
            'message' => 'Follow-up saved successfully.',
            'call_followup_id' => $call_followup_id
        ]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Execution failed: ' . $stmt->error]);
    }

    $stmt->close();
    $conn->close();

} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
}
?>
