<?php 
session_start();
include 'connection.php';

header('Content-Type: application/json');

// Check login
if (!isset($_SESSION['is_logged_in'])) {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit();
}

// Handle POST request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $colour = trim($_POST['colour'] ?? '');

    if (empty($colour)) {
        echo json_encode(['status' => 'error', 'message' => 'Colour is required.']);
        exit();
    }

    $colour = mysqli_real_escape_string($conn, $colour);

    // Check for duplicate colour
    $checkQuery = "SELECT COUNT(*) AS count FROM colour_master WHERE LOWER(colour) = LOWER(?)";
    $stmt = mysqli_prepare($conn, $checkQuery);
    mysqli_stmt_bind_param($stmt, "s", $colour);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_bind_result($stmt, $count);
    mysqli_stmt_fetch($stmt);
    mysqli_stmt_close($stmt);

    if ($count > 0) {
        echo json_encode(['status' => 'error', 'message' => 'Duplicate: Colour already exists.']);
        exit();
    }

    // Insert new colour with default status = 1
    $insertQuery = "INSERT INTO colour_master (colour, status) VALUES (?, 1)";
    $stmt = mysqli_prepare($conn, $insertQuery);
    mysqli_stmt_bind_param($stmt, "s", $colour);

    if (mysqli_stmt_execute($stmt)) {
        echo json_encode([
            'status' => 'success',
            'message' => 'Colour inserted successfully.',
            'colour' => htmlspecialchars($colour)
        ]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Insert failed: ' . mysqli_stmt_error($stmt)]);
    }

    mysqli_stmt_close($stmt);
}
?>
