<?php
include 'connection.php'; // your db config

$location = $_POST['location'] ?? '';

if ($location != '') {
    // Wrap with % for partial match
    $search = "%" . $location . "%";

   $query = "SELECT DISTINCT pincode FROM pincode_location WHERE location LIKE ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("s", $search);
    $stmt->execute();
    $result = $stmt->get_result();

    $pincodes = [];
    while ($row = $result->fetch_assoc()) {
        $pincodes[] = $row['pincode'];
    }

    if (count($pincodes) == 1) {
        // Single pincode ? show input prefilled
        echo '<input type="text" class="form-control" name="pincode" id="pincode" '.
             'value="'.$pincodes[0].'" readonly>';
    } elseif (count($pincodes) > 1) {
        // Multiple pincodes ? show dropdown
        echo '<select name="pincode" id="pincode" class="form-control select2" required>';
        echo '<option value="">Select Pincode</option>';
        foreach ($pincodes as $pin) {
            echo '<option value="'.$pin.'">'.$pin.'</option>';
        }
        echo '</select>';
    } else {
        // No match ? show blank input
        echo '<input type="text" class="form-control" name="pincode" id="pincode" '.
             'pattern="\\d{6}" maxlength="6" minlength="6" required '.
             'title="Enter a 6-digit pincode">';
    }
}
?>
