<?php
include 'connection.php';

if (isset($_POST['location_name'])) {
    $location_name = $_POST['location_name'];

    $stmt = $conn->prepare("SELECT pincode, state FROM location_master WHERE location_name = ? LIMIT 1");
    $stmt->bind_param("s", $location_name);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($row = $result->fetch_assoc()) {
        echo json_encode([
            'success' => true,
            'data' => [
                'pincode' => $row['pincode'],
                'state' => $row['state']
            ]
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Location not found'
        ]);
    }
}
?>
