<?php
require 'connection.php';

if (!isset($_GET['order_id'])) {
    die("Missing order ID");
}

$order_id = intval($_GET['order_id']);

header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=order_$order_id.xls");

echo "<table border='1'>";

// Order Header
$order_sql = "SELECT order_no, order_date, customer_name, order_type FROM order_form WHERE order_id = ?";
$stmt = $conn->prepare($order_sql);
$stmt->bind_param("i", $order_id);
$stmt->execute();
$order_result = $stmt->get_result();
$order = $order_result->fetch_assoc();

echo "<tr><th colspan='2'>Customer Name</th><td colspan='2'>{$order['customer_name']}</td></tr>";
echo "<tr><th>Order No</th><td>{$order['order_no']}</td><th>Order Date</th><td>{$order['order_date']}</td></tr>";
echo "<tr><th colspan='2'>Order Type</th><td colspan='2'>{$order['order_type']}</td></tr>";
echo "</table><br>";

// Order Details
$sql = "SELECT * FROM order_details WHERE order_id = ? ORDER BY id ASC";
$stmt2 = $conn->prepare($sql);
$stmt2->bind_param("i", $order_id);
$stmt2->execute();
$result = $stmt2->get_result();

$sections = [];
while ($row = $result->fetch_assoc()) {
    $sections[$row['section_name']][] = $row;
}

foreach ($sections as $section => $rows) {
    echo "<table border='1'>";
    echo "<tr><th colspan='10' style='background:#ccc;'>$section</th></tr>";

    $key = strtolower(trim($section));
    switch ($key) {
        case 'shutters':
            echo "<tr><th>Sr.NO.</th><th>PRODUCT</th><th>COLOUR</th><th>WIDTH</th><th>HEIGHT</th><th>QTY</th><th>Handle</th><th>Backing</th></tr>";
            break;
        case 'cabinet':
            echo "<tr><th>Sr.NO.</th><th>PRODUCT</th><th>WIDTH</th><th>DEPTH</th><th>HEIGHT</th><th>QTY</th><th>Material</th><th>Remarks</th></tr>";
            break;
        case 'partition and framing':
        case 'tandem base and back':
            echo "<tr><th>Sr.NO.</th><th>PRODUCT</th><th>COLOUR</th><th>WIDTH</th><th>HEIGHT</th><th>QTY</th><th>Material</th><th>Remarks</th></tr>";
            break;
        case 'hardware':
            echo "<tr><th>PRODUCT NAME</th><th>QTY</th><th>UNIT</th></tr>";
            break;
        case 'accessories':
            echo "<tr><th>PRODUCT NAME</th><th>Brand</th><th>Code</th><th>QTY</th></tr>";
            break;
        default:
            echo "<tr><th>PRODUCT</th><th>QTY</th></tr>";
    }

    $sr = 1;
    foreach ($rows as $row) {
        switch ($key) {
            case 'shutters':
                echo "<tr><td>$sr</td><td>{$row['product']}</td><td>{$row['colour']}</td><td>{$row['width']}</td><td>{$row['height']}</td><td>{$row['qty']}</td><td>{$row['handle']}</td><td>{$row['remark']}</td></tr>";
                break;
            case 'cabinet':
                echo "<tr><td>$sr</td><td>{$row['product']}</td><td>{$row['width']}</td><td>{$row['depth']}</td><td>{$row['height']}</td><td>{$row['qty']}</td><td>{$row['unit']}</td><td>{$row['remark']}</td></tr>";
                break;
            case 'partition and framing':
            case 'tandem base and back':
                echo "<tr><td>$sr</td><td>{$row['product']}</td><td>{$row['colour']}</td><td>{$row['width']}</td><td>{$row['height']}</td><td>{$row['qty']}</td><td>{$row['unit']}</td><td>{$row['remark']}</td></tr>";
                break;
            case 'hardware':
                echo "<tr><td>{$row['product']}</td><td>{$row['qty']}</td><td>{$row['unit']}</td></tr>";
                break;
            case 'accessories':
                echo "<tr><td>{$row['product']}</td><td>{$row['brand']}</td><td>{$row['code']}</td><td>{$row['qty']}</td></tr>";
                break;
            default:
                echo "<tr><td>{$row['product']}</td><td>{$row['qty']}</td></tr>";
        }
        $sr++;
    }

    echo "</table><br>";
}
?>
