<?php
include 'connection.php';
session_start();

if (!isset($_SESSION['is_logged_in'])) {
    header("Location: login.php");
    die();
}

// Set headers to output Excel file
header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=customer_leads.xls");
header("Pragma: no-cache");
header("Expires: 0");

$filters = [];

if (!empty($_GET['customer_name'])) {
    $customer_name = mysqli_real_escape_string($conn, $_GET['customer_name']);
    $filters[] = "customer_name LIKE '%$customer_name%'";
}

if (!empty($_GET['ref_name'])) {
    $ref_name = mysqli_real_escape_string($conn, $_GET['ref_name']);
    $filters[] = "ref_name LIKE '%$ref_name%'";
}

if (!empty($_GET['branch'])) {
    $branch = mysqli_real_escape_string($conn, $_GET['branch']);
    $filters[] = "Branch = '$branch'";
}

if (!empty($_GET['architech_name'])) {
    $architech_name = mysqli_real_escape_string($conn, $_GET['architech_name']);
    $filters[] = "architech_name LIKE '%$architech_name%'";
}

if (!empty($_GET['from_date']) && !empty($_GET['to_date'])) {
    $from_date = mysqli_real_escape_string($conn, $_GET['from_date']);
    $to_date = mysqli_real_escape_string($conn, $_GET['to_date']);
    $filters[] = "qtn_date BETWEEN '$from_date' AND '$to_date'";
} elseif (!empty($_GET['from_date'])) {
    $from_date = mysqli_real_escape_string($conn, $_GET['from_date']);
    $filters[] = "qtn_date >= '$from_date'";
} elseif (!empty($_GET['to_date'])) {
    $to_date = mysqli_real_escape_string($conn, $_GET['to_date']);
    $filters[] = "qtn_date <= '$to_date'";
}

$whereClause = !empty($filters) ? "WHERE " . implode(" AND ", $filters) : "";
$sql = "SELECT * FROM customer_leads $whereClause ORDER BY lead_id DESC";
$result = $conn->query($sql);

echo "<table border='1'>";
echo "<tr>
        <th>Sr. No.</th>
        <th>Client/Architect Name</th>
        <th>Quotation Amount</th>
        <th>Quote Last Offered</th>
        <th>Date</th>
        <th>Store Name</th>
        <th>Reference</th>
        <th>Client No.</th>
        <th>Remarks</th>
      </tr>";

if ($result && $result->num_rows > 0) {
    $sr = 1;
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>{$sr}</td>";
        echo "<td>{$row['customer_name']}" . (!empty($row['architech_name']) ? " / {$row['architech_name']}" : "") . "</td>";
        echo "<td>{$row['quotation_amt']}</td>";
        echo "<td>{$row['quotation_amt']}</td>";
        echo "<td>{$row['qtn_date']}</td>";
        echo "<td>{$row['Branch']}</td>";
        echo "<td>{$row['ref_name']}</td>";
        echo "<td>{$row['mobile']}</td>";
        echo "<td>{$row['remark']}</td>";
        echo "</tr>";
        $sr++;
    }
} else {
    echo "<tr><td colspan='9'>No records found</td></tr>";
}
echo "</table>";
$conn->close();
?>
