<?php
session_start();
include 'connection.php';
header('Content-Type: application/json');

if (!isset($_SESSION['is_logged_in'])) {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $colourid = intval($_POST['colourid'] ?? 0);

    if ($colourid <= 0) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid ID']);
        exit();
    }

    $deleteQuery = "DELETE FROM colour_master WHERE colourid = ?";
    $stmt = mysqli_prepare($conn, $deleteQuery);
    mysqli_stmt_bind_param($stmt, "i", $colourid);

    if (mysqli_stmt_execute($stmt)) {
        echo json_encode(['status' => 'success']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Delete failed: ' . mysqli_stmt_error($stmt)]);
    }

    mysqli_stmt_close($stmt);
}
?>
